import os

def count_questions(file_path):
    question_count = 0
    
    with open(file_path, 'r', encoding='utf-8') as f:
        content = f.read()
        question_count = content.count("The answer is")
    
    return question_count

folder_path = "/clean_data"

for filename in os.listdir(folder_path):
    if filename.endswith(".txt"):
        file_path = os.path.join(folder_path, filename)
        total_questions = count_questions(file_path)
        print(f"Number of questions in file {filename}: {total_questions}")